/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.client.gui.CreatureInventoryScreen;
import com.lycanitesmobs.client.gui.beastiary.CreaturesBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.ElementsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.IndexBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.PetsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.SummoningBeastiaryScreen;
import com.lycanitesmobs.client.gui.overlays.MinionSelectionOverlay;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public static GuiHandler instance;

    public GuiHandler() {
        instance = this;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == GuiType.TILEENTITY.id) {
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityBase) {
                return ((TileEntityBase)tileEntity).getGUI(player);
            }
        } else if (id == GuiType.ENTITY.id) {
            Entity entity = world.func_73045_a(x);
            if (entity instanceof BaseCreatureEntity) {
                return new CreatureContainer((BaseCreatureEntity)entity, player.field_71071_by);
            }
        } else if (id == GuiType.ITEM.id) {
            // empty if block
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == GuiType.TILEENTITY.id) {
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityBase) {
                return ((TileEntityBase)tileEntity).getGUI(player);
            }
        } else if (id == GuiType.ENTITY.id) {
            Entity entity = world.func_73045_a(x);
            if (entity instanceof BaseCreatureEntity) {
                return new CreatureInventoryScreen((BaseCreatureEntity)entity, player.field_71071_by);
            }
        } else if (id != GuiType.ITEM.id) {
            if (id == GuiType.BEASTIARY.id) {
                if (x == Beastiary.INDEX.id) {
                    return new IndexBeastiaryScreen(player);
                }
                if (x == Beastiary.CREATURES.id) {
                    return new CreaturesBeastiaryScreen(player);
                }
                if (x == Beastiary.PETS.id) {
                    return new PetsBeastiaryScreen(player);
                }
                if (x == Beastiary.SUMMONING.id) {
                    return new SummoningBeastiaryScreen(player);
                }
                if (x == Beastiary.ELEMENTS.id) {
                    return new ElementsBeastiaryScreen(player);
                }
            } else if (id == GuiType.PLAYER.id && x == PlayerGuiType.MINION_SELECTION.id) {
                return new MinionSelectionOverlay(player);
            }
        }
        return null;
    }

    public static enum PlayerGuiType {
        MINION_SELECTION(0);

        public byte id;

        private PlayerGuiType(byte i) {
            this.id = i;
        }
    }

    public static enum Beastiary {
        INDEX(0),
        CREATURES(1),
        PETS(2),
        SUMMONING(3),
        ELEMENTS(4);

        public byte id;

        private Beastiary(byte i) {
            this.id = i;
        }
    }

    public static enum GuiType {
        TILEENTITY(0),
        ENTITY(1),
        ITEM(2),
        BEASTIARY(3),
        PLAYER(4);

        public byte id;

        private GuiType(byte i) {
            this.id = i;
        }
    }
}

